﻿namespace Microsoft.Samples.PlanMyNight.Web
{
    using System;
    using System.Web;
    using System.Web.Mvc;

    public class JsonCacheAttribute : OutputCacheAttribute
    {
        public override void OnResultExecuting(ResultExecutingContext filterContext)
        {
            if (filterContext == null)
            {
                throw new ArgumentNullException("filterContext");
            }

            if (IsAjax(filterContext.HttpContext.Request))
            {
                base.OnResultExecuting(filterContext);
            }
        }

        private static bool IsAjax(HttpRequestBase request)
        {
            return !string.IsNullOrEmpty(request.ContentType) && request.ContentType.Contains("application/json");
        }
    }
}
